/*
	Signature Code
	Copyright © 2019 Harry Whitfield

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License as
	published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this program; if not, write to the Free
	Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
	MA  02110-1301  USA

	Signature Code - version 1.0 for Display Signature Web widget
	10 October, 2019
	Copyright © 2019 Harry Whitfield
	mailto:g6auc@arrl.net
*/

/*jslint browser, devel, for */

/*property
    DONE, addEventListener, byteLength, dataTransfer, dropEffect, files,
    getElementById, lastModified, lastModifiedDate, length, name, onload,
    onloadend, opacity, preventDefault, readAsArrayBuffer, readyState, result,
    size, slice, stopPropagation, style, target, textContent, toString,
    toUpperCase, type
*/

var window;
var document;
var File;
var FileReader;
var FileList;
var Blob;

var fileTypeFromSignature;

window.onload = function () {
    "use strict";
	var dropArrow = document.getElementById("dropArrow");
    var dropZone = document.getElementById("dropZone");
	var fileInput = document.getElementById("fileInput");
    var nameArea = document.getElementById("nameArea");
    var signatureArea = document.getElementById("signatureArea");

	var write = function (s) {
		signatureArea.textContent = s;
	};

	var action = function (b) {
		var a;
		var len;
		var maxLen = 0x200;
		var hex = "";
		var i;
		var res;

		var osig;
		var extn;
		var desc;

		function min(a, b) {
			return (
				b < a
				? b
				: a
			);
		}

		function toHex(val) {
			var hx = val.toString(16).toUpperCase();

			if (hx.length < 2) {
				hx = "0" + hx;
			}
			return hx;
		}

		if (b.byteLength !== 0) {
			a = new Uint8Array(b);

			len = min(a.length, maxLen);

			for (i = 0; i < len; i += 1) {
				if (hex !== "") {
					hex += " ";
				}
				hex += toHex(a[i]);
			}

			res = fileTypeFromSignature(hex);
			if (res !== null) {
				osig = res[0];
				extn = res[1];
				desc = res[2];
				write("Signature: " + osig + " [" + extn + "] - " + desc);
			} else {
				write("[Signature could not be determined.]");
			}
			return;
		}
		write("No data?");
	};
/*
	var readImage = function (file) {
		var reader = new FileReader();

		reader.onload = function () {
			var img = new Image();

			dropZone.innerHTML = "";
			img.src = reader.result;
			dropZone.appendChild(img);
		};
		reader.readAsDataURL(file);
	};
*/
	var readBlob = function (file, start, bytes, callback) {
		var reader = new FileReader();
		var blob = file.slice(start, start + bytes);

		reader.onloadend = function (event) {
			if (event.target.readyState === FileReader.DONE) {
				callback(event.target.result);
			}
		};
		reader.readAsArrayBuffer(blob);
	};

	var handleDrop = function (evt) {
        var files = evt.dataTransfer.files;
        var file = files[0];

        evt.stopPropagation();
        evt.preventDefault();
        dropArrow.style.opacity = 1;
		nameArea.textContent = (
			"File name: " + file.name + ", Size: " + file.size + " bytes, MIME type: " + file.type +
        	", Modified: " + new Date(file.lastModified || file.lastModifiedDate)
        );
		readBlob(file, 0, 32, action);
	};

    var handleDragOver = function (evt) {
        evt.stopPropagation();
        evt.preventDefault();
        evt.dataTransfer.dropEffect = "copy";
        dropArrow.style.opacity = 0;
    };

	var handleDragLeave = function (evt) {
        evt.stopPropagation();
        evt.preventDefault();
        dropArrow.style.opacity = 1;
    };

	var handleSelect = function (evt) {
		var file = fileInput.files[0];

        evt.stopPropagation();
        evt.preventDefault();
		nameArea.textContent = (
			"File name: " + file.name + ", Size: " + file.size + " bytes, MIME type: " + file.type +
        	", Modified: " + new Date(file.lastModified || file.lastModifiedDate)
        );
		readBlob(file, 0, 32, action);
	};

    if (File && FileReader && FileList && Blob) {
        dropZone.addEventListener("dragover", handleDragOver, false);
        dropZone.addEventListener("drop", handleDrop, false);
       	dropZone.addEventListener("dragleave", handleDragLeave, false);
        fileInput.addEventListener("change", handleSelect, false);
    } else {
        alert("File APIs are missing.");
    }
};
